local localizedVariants = {
    ["Accident"] = {
        name = getText("UI_BWOVariantName_Accident"),
        desc = getText("UI_BWOVariantDesc_Accident")
    },
    ["The Protected"] = {
        name = getText("UI_BWOVariantName_The Protected"),
        desc = getText("UI_BWOVariantDesc_The Protected")
    },
    ["Arson"] = {
        name = getText("UI_BWOVariantName_Arson"),
        desc = getText("UI_BWOVariantDesc_Arson")
    },
    ["The Drunkard"] = {
        name = getText("UI_BWOVariantName_The Drunkard"),
        desc = getText("UI_BWOVariantDesc_The Drunkard")
    },
    ["Hiker"] = {
        name = getText("UI_BWOVariantName_Hiker"),
        desc = getText("UI_BWOVariantDesc_Hiker")
    },
    ["The Cash-Out"] = {
        name = getText("UI_BWOVariantName_The Cash-Out"),
        desc = getText("UI_BWOVariantDesc_The Cash-Out")
    },
    ["Original"] = {
        name = getText("UI_BWOVariantName_Original"),
        desc = getText("UI_BWOVariantDesc_Original")
    },
    ["The Hedonist"] = {
        name = getText("UI_BWOVariantName_The Hedonist"),
        desc = getText("UI_BWOVariantDesc_The Hedonist")
    },
    ["The Convict"] = {
        name = getText("UI_BWOVariantName_The Convict"),
        desc = getText("UI_BWOVariantDesc_The Convict")
    },
    ["Car"] = {
        name = getText("UI_BWOVariantName_Car"),
        desc = getText("UI_BWOVariantDesc_Car")
    }
}

local function applyLocalization()
    if not BWOVariants or type(BWOVariants) ~= "table" then
        print("Error: BWOVariants is not available or not a table.")
        return
    end
    for _, variant in ipairs(BWOVariants) do
        if type(variant) == "table" and variant.name then
            local loc = localizedVariants[variant.name]
            if loc and type(loc) == "table" then
                variant.name = loc.name
                variant.desc = loc.desc
            end
        end
    end
    print("Localization patch applied to BWOVariants at " .. os.date("%H:%M:%S"))
end

Events.OnGameBoot.Add(applyLocalization)